#!/usr/local/bin/perl5 -w
#
#	randimg
#
#	Generate a random image on a system with or without SSI.
#
#	Usage:
#	    <img src="http://cgi.peak.org/randimg.cgi?directory">
#	    <img src="http://cgi.peak.org/~regan/randimg.cgi?~regan/Images/">
#       Put a file named .ImageDir in that directory.
#
#	Note that at least some browsers treat the above URL as a cachable
#	entity, and will only get one copy per run.  To combat this, add
#	&number to the end of each URL such as:
#	    <img src="http://cgi.peak.org/~regan/randimg.cgi?~regan/Images/&1">
#	    <img src="http://cgi.peak.org/~regan/randimg.cgi?~regan/Images/&2">
#
#	It would probably be reasonable to put a expire on the generated image.
#	If that would work, then the above hack won't be needed.  OK.  That is now
#	in the code so it "shouldn't" need the hack.  If this proves out, then
#	remove all of these comments.  If it doesn't work, then we'll need more
#	thought into cheating the cache.
#

###
###	Main program
###

    srand(time ^ $$ ^ ($$ << 14) ^ ($ENV{'REMOTE_PORT'} << 4));
#print STDERR "Random is ", time ^ $$ ^ ($$ << 14) ^ ($ENV{'REMOTE_PORT'} << 4), "\n";
#   printenv();
    $| = 1;
    ($dir = $ENV{'QUERY_STRING'}) =~ s/\&.*//;
    ProcessQuery(GetDirectory($dir));
    exit 0;


###
###	Error
###
###	Print out an error message.
###
sub Error
    {
    my($msg) = @_;

    print "Content-type: text/html\n\n";
    print "<html><head><title>Error</title></head><body>\n";
    print "$msg\n</body></html>\n";
    exit 0;
    }


###
###	GetDirectory
###
###	Get a directory name.  The filename is in web format.
###	Remove any leading .. stuff.
###
###	This gets a directory name in filesystem space regardless
###	of if the reference was a ~user reference, or a system
###	reference.
###
sub GetDirectory
    {
    my($webname) = @_;
    my($root, $user);

    $webname =~ s#\.\./##g;	# Watch out for trickery
    $root = $ENV{'DOCUMENT_ROOT'};
    if ($webname =~ m#^/*~(\w+)/(.*)#)
    	{
    	$webname = $2;
    	$user = $1;
    	$root = (getpwnam($user))[7] . "/public_html";
    	}
    return "$root/$webname";
    }


###
###     printenv
###
###     Display the environment.
###	This assumes that we can write on stdout.  This may not
###	be true if we haven't written the header line yet.
###
sub printenv
    {
    my($var);

    print "Content-type: text/html\n\n";
    for $var (sort(keys %ENV))
        {
        print "$var=$ENV{$var}<br>\n";
        }
    }


###
###	ProcessQuery
###
###	Given a directory name, look for the image files and return
###	a random entry.
###
sub ProcessQuery
    {
    my($dir) = @_;
    my($buf, $file, @images, @img2, $type, $winner);

    # Ensure that the directory is reasonable to read files from.
    if (! -f "$dir/.ImageDir")
    	{
    	Error("$dir does not contain a file named <b>.ImageDir</b>\n");
    	}

    @images = glob "$dir/*";
    for $file (@images)
    	{
    	# Select just the graphics files
    	push(@img2, $file) if ($file =~ /\.(gif|jpg|jpeg)$/i);
    	}

    $winner = $img2[rand($#img2 + 1)];
    $type = "gif";
    $type = "jpeg" if ($winner =~ /\.(jpg|jpeg)$/i);
#   print STDERR "Returning $winner, type $type\n";
    if (!open(IMG, "<$winner"))
    	{
    	Error("Cannot open $winner\n");
    	}
    print "Expires: Thursday, 01-Jan-70 00:00:00 GMT\n";
    print "Date: Fri, 07 Aug 1998 23:38:37 GMT\n";
    print "Pragma: no-cache\n";
    print "Content-type: image/$type\n";
    print "Content-length: ", -s $winner, "\n\n";
    $buf = "";
    while (read(IMG, $buf, 4096))
	{
	print $buf;
	}
    close IMG;
    }
